c      *************************************************************
c      AN AR(p) - ASYMMETRIC MA(q) ML ESTIMATION-WALD TEST PROGRAM
c      (WITH FORECAST OPTION)
c      Coded by K Brnns Nov 1990 / Feb 1991 / Sept 1992 / Nov 1993
c      *************************************************************
       common fto,cqrt
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       real gs(30),R(15,30),rr(15,15),rv(15,15),u(5500,15)
       real u1(5500,15),f3(15),f4(15),f5(15),f6(15),heav(15)
       real u2(5500,15),u3(5500),f7(15),f8(15)
       integer idd(20)
       integer p,pinc,q,qincp,qincm,ipar1
       character *40 ifile
       character *40 ifil
       character *40 iout  
	idum3=-1 
       fto=.0000001
       cqrt=.01
	iiter=5
       do 1996 i=1,20
1996   idd(i)=i
       write(*,*)char(27),'[44m',char(27),'[1m'
       write(*,*)char(27),'[37m'
       call top
       write(*,*)' '
       write(*,*)' DATA INPUT FILE : '
       read(*,100)ifile
       open(1,file=ifile)
       write(*,*)' PARAMETER INPUT FILE : '
       read(*,100)ifil
       open(2,file=ifil)
       write(*,*)' RESULT FILE : '
       read(*,100)iout
       open(3,file=iout)
100    format(a40)
       idiff=0
       idiffs=0
       ilog=0
       read(2,*)m,pinc,qincp,qincm
       ipar1=pinc+qincp
       ipar=ipar1+qincm
       ipar2=ipar+1
       i2q=qincp+qincm
       read(2,*)(ip(i),i=1,pinc)
       read(2,*)(iresp(i),i=1,qincp)
       read(2,*)(iresm(i),i=1,qincm)
       read(2,*)(b(i),i=1,ipar)
	q=max(iresp(qincp),iresm(qincm))
       imi=max(ip(pinc),q)+1
       b(ipar2)=0.
       read(1,*)(y(i),i=1,m)           
987	call top
       write(*,*)' '
       write(*,*)' POSSIBLE ACTIONS '
       write(*,*)'  1. Estimate and test'
       write(*,*)'  2. Initial estimation'
       write(*,*)'  3. Series and residual to file'
       write(*,*)'  4. Invertibility check'
       write(*,*)'  5. Transformation of series'
       write(*,*)'  6. Model specification'
       write(*,*)'  7. Iteration criteria'
       write(*,*)'  8. Autocorrelation function'
       write(*,*)' 10. Forecast h=4 ahead'
       write(*,*)'  9. Exit'
       write(*,*)' CHOOSE NR: '
       read(*,*)nr
9877   continue
c*************
	if(nr.eq.10)then
	call forec
	goto 987
	endif
c*************
	if(nr.eq.4)then
	call inv
	goto 987
	endif
c*************
       if(nr.eq.7)then
	call setasma(iiter)
       goto 987
	endif
c************
       if(nr.eq.6)then
       write(*,*)char(27),'[2J'       
   	   write(*,*)'  Present Model Specification'
	   write(*,*)' '
       write(*,*)'  ARasMA(',p,qincp,qincm,') d=',idiff,'D=',idiffs
	   if(ilog.eq.1)write(*,*)'  Log-Transform'
	   write(*,*)'  Included AR-lags  : ',(ip(i),i=1,pinc)
	   write(*,*)'  Included asMA+lags: ',(iresp(i),i=1,qincp)	   
	   write(*,*)'  Included asMA-lags: ',(iresm(i),i=1,qincm)	   
	   write(*,1112)(b(i),i=1,pinc)
1112   format('  AR-parameters        : ',10f6.2)
       write(*,1113)(b(i),i=pinc+1,ipar1)
1113   format('  asMA+parameters      : ',10f6.2)
       write(*,1114)(b(i),i=ipar1+1,ipar)
1114   format('  asMA-parameters      : ',10f6.2)
       write(*,*)' '
	   write(*,*)'  CHANGE in AR ? (yes=1): '
	   read(*,*)ija
	   if(ija.eq.1)then
	   write(*,*)'  GIVE P, Nr of included lags :'
	   read(*,*)p,pinc
	   write(*,*)'  GIVE LAGS, INITIAL GUESSES :'
	   read(*,*)(ip(i),i=1,pinc),(b(i),i=1,pinc)
	   endif
       write(*,*)'  CHANGE in asMA+? (yes=1): '
       read(*,*)ija
	   if(ija.eq.1)then
	do 414 i=1,qincp
	iresp(i)=0
414	b(i+pinc)=0
	qold=qincp
	   write(*,*)'  GIVE NR OF INCLUDED asMA+ LAGS     :'
	   read(*,*)qincp
	   write(*,*)'  GIVE LAGS, INITIAL GUESSES OF asMA+:'
	   read(*,*)(iresp(i),i=1,qincp),(b(i),i=pinc+1,pinc+qincp)
	do 4141 i=1,qincm
4141	b(i+pinc+qincp)=b(i+pinc+qold)
	   endif
       write(*,*)'  CHANGE in asMA-? (yes=1): '
       read(*,*)ija
	   if(ija.eq.1)then
	do 4142 i=1,qincm
	iresm(i)=0
4142	b(i+pinc)=0
	   write(*,*)'  GIVE NR OF INCLUDED asMA- LAGS     :'
	   read(*,*)qincm
           i2q=qincp+qincm
	   write(*,*)'  GIVE LAGS, INITIAL GUESSES OF asMA-:'
	   read(*,*)(iresm(i),i=1,qincm),(b(i),i=pinc+qincp+1,pinc+i2q)
       endif
        ipar1=pinc+qincp
        ipar=ipar1+qincm
	ipar2=ipar+1
	q=max(iresp(qincp),iresm(qincm))
        imi=max(ip(pinc),q)+1
	b(ipar2)=0.
        goto 987
	endif
c**************
       if(nr.eq.8)then
       write(*,*)char(27),'[2J'       
       call acf(chiLB,chiNORM,ht,20)
       write(*,*)' '
       write(*,*)' LAG - AUTOCORRELATIONS'
       do 1997 i=1,20
1997   write(*,1999)idd(i),bb(i)
1999   format(i5,f10.2)
	pause 
	goto 987
       endif
c************
	   if(nr.eq.5)then
           write(*,*)' TRANSFORMATIONS'
	   write(*,*)'  (1) FOR LOGARITHM'
	   write(*,*)'  (2) FOR 1st DIFFERENCING'
	   write(*,*)'  (3) FOR ANNUAL DIFFERENCE (QUARTERLY DATA)'
	   write(*,*)'  (4) FOR ANNUAL DIFFERENCE (MONTHLY DATA)'
	   write(*,*)'  (5) WRITE SERIES TO FILE'
	   write(*,*)'  (9) RETURN TO MAIN MENU'
	   write(*,*)' CHOOSE NR: '	   
	   read(*,*)nrr
	   if(nrr.eq.1)then
	   do 423 i=1,m
423	   y(i)=log(y(i))
           ilog=1
           endif
	   if(nrr.eq.2)then
	   idiff=idiff+1
	   do 424 i=1,m-1
424	   y(i)=y(i+1)-y(i)
           m=m-1
	   endif
	   if(nrr.eq.3)then
	   idiffs=idiffs+1
	   do 425 i=1,m-4
425	   y(i)=y(i+4)-y(i)
	   m=m-4
	   endif
	   if(nrr.eq.5)then
	   do 426 i=1,m
426	   write(3,*)y(i)
           endif
	   if(nrr.eq.4)then
	   idiffs=idiffs+2
	   do 825 i=1,m-12
825	   y(i)=y(i+12)-y(i)
	   m=m-12
	   endif
	   goto 987
	   endif
c***********
       if(nr.eq.9)goto 996
c***********
	if(nr.eq.2)then
	write(*,*)' INITIAL ESTIMATION'
	call amspp(fmin,iterx)
	write(*,*)' Phase... 1',iterx,' evaluations'
	call amspp(fmin,iterx)
	write(*,*)' Phase... 2',iterx,' evaluations'
	write(*,*)' Suggest you choose menu option 1 next...'
	pause
	goto 987
	endif
c***********
919    if(nr.eq.1)then
	do 4413 i=1,iiter
        call amsp(fmin,itera)	
4413  write(*,*)' Iteration...',i,' Function ',fmin,' Evaluations',itera
       hm=-0.5*m	 
       y1=0
       y2=0  
       do 634 i=1,m
       y1=y1+y(i)
634    y2=y2+y(i)*y(i)
       sy2=y2-y1*y1/float(m)
       do 1 i=1,imi
       u3(i)=0
       e(i)=0
       do 999 j=1,10
       u(i,j)=0
       u2(i,j)=0
999    u1(i,j)=0
       do 1 j=1,30
1      h(i,j)=0
       do 7 i=1,10
       w(i)=0
7      w1(i)=0       
       ht=0
        do 90 it=imi,m
        do 5652 i=1,q
 	heav(i)=0
        if(e(it-i).ge.0)heav(i)=1
	w(i)=heav(i)*e(it-i)
5652	w1(i)=(1-heav(i))*e(it-i)
        f1=0
        f2=0
        do 5 i=1,qincp
5	f1=f1+b(i+pinc)*e(it-iresp(i))*heav(iresp(i))
        do 6 i=1,qincm
6	f2=f2+b(i+ipar1)*e(it-iresm(i))*(1-heav(iresm(i)))
	do 21 j=1,pinc
        v7=0
	v8=0
	do 12 i=1,qincp
12	v7=v7+b(i+pinc)*u2(it-iresp(i),j)*heav(iresp(i))
	do 1332 i=1,qincm
1332	v8=v8+b(i+ipar1)*u2(it-iresm(i),j)*(1-heav(iresm(i)))
        f7(j)=v7
21	f8(j)=v8
	v9=0
	v10=0
	do 22 i=1,qincp
22	v9=v9+b(i+pinc)*u3(it-iresp(i))*heav(iresp(i))
	do 223 i=1,qincm
223	v10=v10+b(i+ipar1)*u3(it-iresm(i))*(1-heav(iresm(i)))
	do 15 j=1,qincp
	v3=0
	v5=0
	do 9 i=1,qincp
	v3=v3+b(i+pinc)*u(it-iresp(i),j)*heav(iresp(i))
9	v5=v5+b(i+pinc)*u1(it-iresp(i),j)*heav(iresp(i))
	f3(j)=v3
15	f5(j)=v5 
	do 152 j=1,qincm
	v4=0
	v6=0
	do 92 i=1,qincm
	v4=v4+b(i+ipar1)*u(it-iresm(i),j)*(1-heav(iresm(i)))
92	v6=v6+b(i+ipar1)*u1(it-iresm(i),j)*(1-heav(iresm(i)))
	f4(j)=v4
152	f6(j)=v6 
	u3(it)=-1-v9-v10
       f33=0	   
       do 11 i=1,pinc
       ylag(i)=y(it-ip(i))
       u2(it,i)=-ylag(i)-f7(i)-f8(i)
11     f33=f33+ylag(i)*b(i)
       do 23 i=1,qincp
23     u(it,i) =-w(i) -f3(i)-f4(i)
       do 232 i=1,qincm
232    u1(it,i)=-w1(i)-f5(i)-f6(i)
       e(it)=y(it)-f1-f2-f33-b(ipar2)
       ht=ht+e(it)*e(it)
       do 112 i=1,pinc
112    g(i)      =-e(it)*u2(it,i)/b(ipar2+1)
       do 66 i=1,qincp
66     g(i+pinc) =-e(it)*u(it,i) /b(ipar2+1)
       do 67 i=1,qincm	
67     g(i+pinc+qincp)=-e(it)*u1(it,i)/b(ipar2+1)
	ipar2=pinc+qincp+qincm+1
       g(ipar2)  =-e(it)*u3(it)/b(ipar2+1)
       do 13 i=1,ipar2
       do 13 j=1,ipar2
13     h(i,j)=h(i,j)+g(i)*g(j)
90     continue
       call matinv(is,iss,ipar2,ipar2,h,30,gs,det)
       do 133 i=1,ipar2
133	if(h(i,i).le.0.)h(i,i)=.00000001
	call top
       write(3,1111)pinc,qincp,qincm
1111   format(' ARasMA(',i2,';',i2,';',i2,')-#lags')
       write(3,1314)(ip(i),i=1,pinc)
1314   format(' AR-lags  : ',10i3)
       write(3,1115)(iresp(i),i=1,qincp),(iresm(i),i=1,qincm)
1115   format(' asMA(+:-)lags: ',20i3)
       write(3,*)' Difference (1=yes)             :',idiff
       write(3,*)' Seasonal (4=1;12=2) difference :',idiffs
       write(3,*)' Logarithm (1=yes)              :',ilog
	write(3,*)' '
       write(*,*)' PARAMETER ESTIMATES '
      write(*,*)'     LAG     VALUE        SE         t         
     a  t'
      write(3,*)'     LAG     VALUE        SE         t         
     a  t'
       do 88 i=1,pinc
       se=sqrt(h(i,i))
3      ttest=b(i)/se
       write(3,101)ip(i),b(i),se,ttest
88     write(*,101)ip(i),b(i),se,ttest
101    format('   AR ',i3,3f10.5)
       do 91 i=1,qincp
       se=sqrt(h(pinc+i,pinc+i))
       ttest=b(i+pinc)/se
       write(3,103)iresp(i),b(i+pinc),se,ttest
91     write(*,103)iresp(i),b(i+pinc),se,ttest
103    format(' asMA+',i3,3f10.5)
       do 89 i=1,qincm
       se=sqrt(h(qincp+pinc+i,qincp+pinc+i))
       ttest=b(i+qincp+pinc)/se
	de=0
	ia=0
	do 3134 j=1,qincp
	if(iresm(i).eq.iresp(j))then
	ia=1
	de=b(j+pinc)-b(i+ipar1)
        sde=h(pinc+j,pinc+j)+h(ipar1+i,ipar1+i)-2*h(pinc+j,ipar1+i)
	if(sde.le.0)sde=.000000001
	tde=de/sqrt(sde)
        write(3,105)iresm(i),b(i+ipar1),se,ttest,de,tde
        write(*,105)iresm(i),b(i+ipar1),se,ttest,de,tde
	endif
3134	continue
	if(ia.ne.1)then
        write(3,105)iresm(i),b(i+ipar1),se,ttest
        write(*,105)iresm(i),b(i+ipar1),se,ttest
	endif
89	continue
105    format(' asMA-',i3,5f10.5)
       se=sqrt(h(ipar2,ipar2))
       ttest=b(ipar2)/se
       write(3,1121)b(ipar2),se,ttest
       write(*,1121)b(ipar2),se,ttest
1121   format(' Const   ',3f10.5)
       s2k=HT/FLOAT(M)
	   htl=hm*log(s2k)-0.5*ht/s2k
	   aic=log(s2k)+2.*ipar2/float(m)
	   sbic=log(s2k)+ipar2*log(float(m))/float(m)
           r2=1.-ht/sy2
	   write(3,102)s2k,aic,sbic,r2,htl
       write(*,102)s2k,aic,sbic,r2,htl
102    FORMAT('    : ',f20.7,/,'   AIC: ',f20.2,'  SBIC:',f21.2,
     a /,'    R: ',f20.2,'  ln L: ',f20.4)
	call acf(chiLB,chiNORM,ht,20)
	   q22=0.5*float(20-ipar2)
	   i23=20-ipar2
	   w22=0.5*chiLB
	   wp=gammq(q22,w22)
	   chin=0.5*chiNORM	
	   uno=1.
	   wpn=gammq(uno,chin)
	write(*,1004)chiLB,wp,i23
	write(3,1004)chiLB,wp,i23
1004	   format(' LJUNG-BOX          :',f10.2,' p-value:',f6.4,
     a ' WITH ',i2,' DF')
	write(*,1005)chiNORM,wpn
	write(3,1005)chiNORM,wpn
1005	   format(' JARQUE-BERA        :',f10.2,' p-value:',f6.4)
998    continue
       do 633 i=1,qincp
	   do 633 j=1,i2q
633	   R(i,j)=0
	   do 639 i=1,qincp
	   R(i,i)=1
639	   r(i,i+q)=-1
       do 6344 j=1,qincp
	   f2=0
	   do 561 i=1,i2q
561	   f2=f2+R(j,i)*b(i+pinc)
6344   w(j)=f2
       do 562 jj=1,qincp
	   do 562 i=1,i2q
	   f33=0
	   do 563 j=1,i2q
563	   f33=f33+R(jj,j)*h(j+pinc,i+pinc)
562	   rr(jj,i)=f33
       do 635 i=1,qincp
	   do 635 j=1,qincp
	   f33=0
	   do 564 jj=1,i2q
564	   f33=f33+rr(i,jj)*r(j,jj)
635    rv(i,j)=f33
       call matinv(is,iss,qincp,qincp,rv,15,ylag,det)
	   do 636 i=1,qincp
	   f33=0
	   do 637 j=1,qincp
637	   f33=f33+w(j)*rv(j,i)
636	   w1(i)=f33
	   f33=0
	   do 638 i=1,qincp
638	   f33=f33+w1(i)*w(i)
	   wald=f33
	   if(wald.le.0.)wald=.00001
	   q22=0.5*float(qincp)
	   w22=0.5*wald
	   if(qincp.le.0)goto 5132
	   wp=gammq(q22,w22)
	   write(*,104)wald,wp,qincp
	   write(3,104)wald,wp,qincp
104	   format(' WALD LINEARITY TEST:',f10.2,' p-value:',f6.4,
     a ' WITH ',i2,' DF')
5132	   continue
4782       continue
           pause 
	   goto 987
	   endif
c**************
       if(nr.eq.3)then
       do 565 i=imi,m
       a=y(i)-e(i)
565    write(3,109)i,y(i),e(i),a
109    format(i5,3f25.8)
       endif
       goto 987
c************

996    continue	   
	call top
       write(*,*)' THANKS FOR USING ASMA !!'
       stop
       end
c***
	subroutine setasma(iiter)	
       common fto,cqrt
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       integer p,pinc,q,qincp,qincm,ipar1
       write(*,*)'  Present settings: '
       write(*,9191)cqrt,fto,iiter
9191   format(' CONSTANT:',f12.9,' FTOL:',f12.9,/,
     a  ' # AMOEBA CALLS',i4)
       write(*,*)'  CHANGE # AMOEBA CALLS? (Yes=1) :'
       read(*,*)ija
       if(ija.eq.1)then
       write(*,*)'  New # CALLS: '
       read(*,*)iiter
       endif
       write(*,*)'  CHANGE CONSTANT? (Yes=1) :'
       read(*,*)ija
       if(ija.eq.1)then
       write(*,*)'  New CONSTANT: '
       read(*,*)cqrt
       endif
       write(*,*)'  CHANGE FTOL? (Yes=1) :'
       read(*,*)ija
       if(ija.eq.1)then
       write(*,*)'  New FTOL    : '
       read(*,*)fto
       endif
	return
	end
c***
	subroutine top
       write(*,*)char(27),'[2J'
       write(*,5134)
       write(*,5133)
       write(*,5135)
5134   format(57(' '),'Ŀ')
5133   format(57(''),' KB ARasMA/CH 2000 ')
5135   format(57(' '),'  ')
	return
	end

       subroutine inv
       common fto,cqrt
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       real u3(5500),u2(5500)
c       ipar1=pinc+qinc
c       ipar=ipar1+qinc
       ipar2=ipar+1
       write(*,*)char(27),'[37m'
       write(*,*)char(27),'[2J'       
       write(*,*)' *** Empirical invertibility ***'
       write(*,*)' '
       write(*,*)'    t      y(t)       e^2'
	if(b(ipar2+1).le.0)then
	write(*,*)' Negative , set = 0.000001'
	b(ipar2+1)=.000001
	endif
	do 4 i=1,m
4	u2(i)=y(i)
       rs=0.075
       mt=999
       call gnorm(u3,mt,rs)
       do 112 it=m+1,999
        f1=0
        f2=0
        u3(it)=sqrt(b(ipar2+1))*u3(it)
	e(it)=u3(it)
        do 55 i=1,qincp
55      if(e(it-iresp(i)).ge.0)f1=f1+b(i+pinc)*e(it-iresp(i))
        do 56 i=1,qincm
56      if(e(it-iresm(i)).le.0)f2=f2+b(i+ipar1)*e(it-iresm(i))
       f33=0	   
       do 121 i=1,pinc
121    f33=f33+u2(it-ip(i))*b(i)
       u2(it)=e(it)+f1+f2+f33+b(ipar2)
112    continue
	ht=0
        do 90 it=m+1,999
       f1=0
       f2=0
       f3=0
	   do 57 i=1,qincp
57	   if(e(it-iresp(i)).ge.0)f1=f1+b(i+pinc)*e(it-iresp(i))
	   do 58 i=1,qincm
58	   if(e(it-iresm(i)).le.0)f2=f2+b(i+ipar1)*e(it-iresm(i))
       do 11 i=1,pinc
11     f3=f3+u2(it-ip(i))*b(i)
       e(it)=u2(it)-f1-f2-f3-b(ipar2)
	ht=ht+(e(it)-u3(it))*(e(it)-u3(it))/float(it-m)
	if(ht.gt.100000)then
	write(*,*)'  ** NONINVERTIBLE MODEL **'
	goto 91
	endif
	if(it.eq.400)write(*,5133)it,u2(it),ht
	if(it.eq.500)write(*,5133)it,u2(it),ht
	if(it.eq.600)write(*,5133)it,u2(it),ht
	if(it.eq.700)write(*,5133)it,u2(it),ht
	if(it.eq.800)write(*,5133)it,u2(it),ht
	if(it.eq.900)write(*,5133)it,u2(it),ht
	if(it.eq.999)write(*,5133)it,u2(it),ht
5133    format(i6,2f10.4)
90      continue
91	continue
	pause
	return
	end

		subroutine gnorm(r,nr,idum3)
		integer nr,idum3
		real r(nr)
		do  1 i=1,nr
99		continue
		v=ran1(idum3)*2.-1.
		u=ran1(idum3)*2.-1.
		w=v*v+u*u
		if(w.gt.1)goto 99
		c=sqrt(-2.*log(w)/w)
		R(i)=c*v
		r(i+1)=c*u
1		continue
		return
		end	
			


	          subroutine acf(chiLB,chiNORM,ht,K)
	 common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
	v=0
	xm=float(m-imi)
	xm1=float(m)
	do 1 i=imi,m
1	v=v+e(i)
	vbar=v/xm	
	v1=0
	v2=0
	ht=0
	do 5 i=imi,m
	a1=e(i)-vbar
	ht=ht+a1*a1
	v1=v1+a1*a1*a1
5	v2=v2+a1*a1*a1*a1
	a3=(v1/ht)*sqrt(xm/ht)
	a4=(v2*xm)/(ht*ht)-3.
	chiNORM=0.166667*xm*(a3*a3+.25*a4*a4)
	do 2 j=1,K
        v=0
	do 3 i=imi,m-j
3	v=v+(e(i)-vbar)*(e(i+j)-vbar)
	bb(j)=v/ht
2	g(j)=bb(j)*bb(j)
	chiLB=0
	do 4 j=1,K
4	chiLB=chiLB+g(j)/(xm1-float(j))
	chiLB=chiLB*xm1*(xm1+2.)
	return
	end
       subroutine amsp(fmin,itera)
	   common fto,cqrt
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       real gq(31),xi(31,31),g1(31)
       integer p,pinc,q,qinc,ipar1
         ep=.367879441		
		   ipar2=ipar+1
		   gq(1)=arasmaf(b)
		   do 56 i=1,ipar2
		   xi(1,i)=b(i)
		   do 57 j=1,ipar2
		   cy=0
		   if(i.eq.j)cy=cqrt
		   g1(j)=b(j)+cy
57		   xi(i+1,j)=g1(j)
		   gq(i+1)=arasmaf(g1)
56		   continue
           call amoeba(xi,gq,31,31,ipar2,fto,arasmaf,itera)
		   fmin=gq(1)
		   imin=1
		   do 58 i=2,ipar2
		   if(gq(i).le.fmin)then
		      imin=i
			  fmin=gq(i)
		   endif
58         continue  
         do 834 i=1,ipar2
834		 b(i)=xi(imin,i)
		 return
		 end   
	   	          subroutine amspp(fmin,iterx)
	   common fto,cqrt
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       real gq(31),xi(31,31),g1(31)
       integer p,pinc,q,qinc,ipar1
         ep=.367879441		
		   ipar2=ipar+1
		   gq(1)=arasmap(b)
		   do 56 i=1,ipar2
		   xi(1,i)=b(i)
		   do 57 j=1,ipar2
		   cy=0
		   if(i.eq.j)cy=cqrt
		   g1(j)=b(j)+cy
57		   xi(i+1,j)=g1(j)
		   gq(i+1)=arasmap(g1)
56		   continue
           call amoeba(xi,gq,31,31,ipar2,fto,arasmap,iterx)
		   fmin=gq(1)
		   imin=1
		   do 58 i=2,ipar2
		   if(gq(i).le.fmin)then
		      imin=i
			  fmin=gq(i)
		   endif
58         continue  
         do 834 i=1,ipar2
834		 b(i)=xi(imin,i)
		 return
		 end   
	subroutine matinv(isol,idsol,nr,nc,a,mra,kwa,det)
                dimension a(1),kwa(1)
                ir=nr
                isol=1
                idsol=1
                if(nr.le.0)goto 330
                if((ir-mra).gt.0)goto 330
                ic=iabs(nc)
                if((ic-ir).lt.0)ic=ir
                ibmp=1
                jbmp=mra
                kbmp=jbmp+ibmp
                nes=ir*jbmp
                net=ic*jbmp
                if(nc)10,330,20
10              mdiv=jbmp+1
                iric=ir-ic
                goto 30
20              mdiv=1
30              mad=mdiv
                mser=1
                kser=ir
                mz=1
                det=1.
40              piv=0.
                i=mser
50              if((i-kser).gt.0)goto 70
                if((abs(a(i))-piv).le.0.)goto 60
                piv=abs(a(i))
                ip=i
60              i=i+ibmp
                goto 50
70              if(piv.eq.0.)goto 340
                if(nc.lt.0)goto 80
                i=ip-((ip-1)/jbmp)*jbmp
                j=mser-((mser-1)/jbmp)*jbmp
                jj=mser/kbmp+1
                ii=jj+(ip-mser)
                kwa(jj)=ii
                goto 90
80              i=ip
                j=mser
90              if(ip-mser)330,120,100
100             if((j-net).gt.0)goto 110
                psto=a(i)
                a(i)=a(j)
                a(j)=psto
                i=i+jbmp
                j=j+jbmp
                goto 100
110             det=-det
120             psto=a(mser)
                det=det*psto
130             if(det.eq.0.)goto 150
140             psto=1./psto
                goto 160
150             idsol=1
                isol=2
                return
160             continue
                a(mser)=1.
                i=mdiv
170             if((i-net).gt.0)goto 180
                a(i)=a(i)*psto
                i=i+jbmp
                goto 170
180             if((mz-kser).gt.0)goto 210
                if((mz-mser).eq.0)goto 200
                i=mad
                j=mdiv
                psto=a(mz)
                if(psto.eq.0)goto 200
                a(mz)=0.
190             if((j-net).gt.0)goto 200
                a(i)=a(i)-a(j)*psto
                j=j+jbmp
                i=i+jbmp
                goto 190
200             mad=mad+ibmp
                mz=mz+ibmp
                goto 180
210             continue
220             kser=kser+jbmp
                if((kser-nes).gt.0)goto 260
                mser=mser+kbmp
                if(nc.lt.0)goto 230
                mdiv=mdiv+ibmp
                mz=((mser-1)/jbmp)*jbmp+1
                mad=1
                goto 40
230             mdiv=mdiv+kbmp
                if(iric.ne.0)goto 240
                mz=mser+ibmp
                goto 250
240             mz=((mser-1)/jbmp)*jbmp+1
250             mad=mz+jbmp
                goto 40
260             if(nc.lt.0)return
                jr=ir
270             if(jr)330,360,280
280             if(kwa(jr)-jr)330,320,290
290             k=(jr-1)*jbmp
                j=k+ir
                l=(kwa(jr)-1)*jbmp+ir
300             if(j-k)330,320,310
310             psto=a(l)
                a(l)=a(j)
                a(j)=psto
                j=j-ibmp
                l=l-ibmp
                goto 300
320             jr=jr-1
                goto 270
330             isol=3
                return
340             det=0.
                isol=2
                idsol=1
                return
350             isol=2
                idsol=2
360             return
                end






      FUNCTION gammq(a,x)
      REAL a,gammq,x
CU    USES gcf,gser
      REAL gammcf,gamser,gln
      if(x.lt.0..or.a.le.0.)pause 'bad arguments in gammq'
      if(x.lt.a+1.)then
        call gser(gamser,a,x,gln)
        gammq=1.-gamser
      else
        call gcf(gammcf,a,x,gln)
        gammq=gammcf
      endif
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      SUBROUTINE amoeba(p,y,mp,np,ndim,ftol,funk,iter)
      INTEGER iter,mp,ndim,np,NMAX,ITMAX
      REAL ftol,p(mp,np),y(mp),funk
      PARAMETER (NMAX=20,ITMAX=5000)
      EXTERNAL funk
CU    USES amotry,funk
      INTEGER i,ihi,ilo,inhi,j,m,n
      REAL rtol,sum,swap,ysave,ytry,psum(NMAX),amotry
      iter=0
1     do 12 n=1,ndim
        sum=0.
        do 11 m=1,ndim+1
          sum=sum+p(m,n)
11      continue
        psum(n)=sum
12    continue
2     ilo=1
      if (y(1).gt.y(2)) then
        ihi=1
        inhi=2
      else
        ihi=2
        inhi=1
      endif
      do 13 i=1,ndim+1
        if(y(i).le.y(ilo)) ilo=i
        if(y(i).gt.y(ihi)) then
          inhi=ihi
          ihi=i
        else if(y(i).gt.y(inhi)) then
          if(i.ne.ihi) inhi=i
        endif
13    continue
      rtol=2.*abs(y(ihi)-y(ilo))/(abs(y(ihi))+abs(y(ilo)))
      if (rtol.lt.ftol) then
        swap=y(1)
        y(1)=y(ilo)
        y(ilo)=swap
        do 14 n=1,ndim
          swap=p(1,n)
          p(1,n)=p(ilo,n)
          p(ilo,n)=swap
14      continue
        return
      endif
      if (iter.ge.ITMAX) goto 999	!!pause 'ITMAX exceeded in amoeba'
      iter=iter+2
      ytry=amotry(p,y,psum,mp,np,ndim,funk,ihi,-1.0)
      if (ytry.le.y(ilo)) then
        ytry=amotry(p,y,psum,mp,np,ndim,funk,ihi,2.0)
      else if (ytry.ge.y(inhi)) then
        ysave=y(ihi)
        ytry=amotry(p,y,psum,mp,np,ndim,funk,ihi,0.5)
        if (ytry.ge.ysave) then
          do 16 i=1,ndim+1
            if(i.ne.ilo)then
              do 15 j=1,ndim
                psum(j)=0.5*(p(i,j)+p(ilo,j))
                p(i,j)=psum(j)
15            continue
              y(i)=funk(psum)
            endif
16        continue
          iter=iter+ndim
          goto 1
        endif
      else
        iter=iter-1
      endif
      goto 2
999		continue
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
       function arasmaf(pp)
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       real pp(31)
       integer p,pinc,q,qincp,qincm,ipar1
       ipar2=ipar+1
	do 8 i=1,imi
8	e(i)=0
	ht=0
       do 90 it=imi,m
       f1=0
       f2=0
       f3=0
	   do 5 i=1,qincp
5	   if(e(it-iresp(i)).ge.0)
     a	   f1=f1+e(it-iresp(i))*pp(i+pinc)
	   do 6 i=1,qincm
6	   if(e(it-iresm(i)).le.0)
     a     f2=f2+e(it-iresm(i))*pp(i+ipar1)
           do 11 i=1,pinc
11         f3=f3+y(it-ip(i))*pp(i)
       e(it)=y(it)-f1-f2-f3-pp(ipar2)
       e22=e(it)*e(it)
90     ht=ht+e22
       arasmaf=float(m)*0.5*log(ht)
	b(ipar2+1)=ht/float(m)
	   return
	   end
       function arasmap(pp)
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       real pp(31)
       integer p,pinc,q,qincp,qincm,ipar1
       ipar2=ipar+1
	do 8 i=1,imi
8	e(i)=0
	ht=0
       do 90 it=imi,m
       f1=0
       f2=0
       f3=0
	   do 5 i=1,qincp
5     f1=f1+e(it-iresp(i))*pp(i+pinc)/(1+exp(-200.*e(it-iresp(i))))
	   do 6 i=1,qincm
6     f2=f2+e(it-iresm(i))*pp(i+ipar1)*
     a  exp(-200*e(it-iresm(i)))/(1+exp(-200.*e(it-iresm(i))))
           do 11 i=1,pinc
11         f3=f3+y(it-ip(i))*pp(i)
       e(it)=y(it)-f1-f2-f3-pp(ipar2)
       e22=e(it)*e(it)
90     ht=ht+e22
       arasmap=float(m)*0.5*log(ht)
	b(ipar2+1)=ht/float(m)
	   return
	   end
      SUBROUTINE gser(gamser,a,x,gln)
      INTEGER ITMAX
      REAL a,gamser,gln,x,EPS
      PARAMETER (ITMAX=100,EPS=3.e-7)
CU    USES gammln
      INTEGER n
      REAL ap,del,sum,gammln
      gln=gammln(a)
      if(x.le.0.)then
        if(x.lt.0.)pause 'x < 0 in gser'
        gamser=0.
        return
      endif
      ap=a
      sum=1./a
      del=sum
      do 11 n=1,ITMAX
        ap=ap+1.
        del=del*x/ap
        sum=sum+del
        if(abs(del).lt.abs(sum)*EPS)goto 1
11    continue
      pause 'a too large, ITMAX too small in gser'
1     gamser=sum*exp(-x+a*log(x)-gln)
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      SUBROUTINE gcf(gammcf,a,x,gln)
      INTEGER ITMAX
      REAL a,gammcf,gln,x,EPS,FPMIN
      PARAMETER (ITMAX=100,EPS=3.e-7,FPMIN=1.e-30)
CU    USES gammln
      INTEGER i
      REAL an,b,c,d,del,h,gammln
      gln=gammln(a)
      b=x+1.-a
      c=1./FPMIN
      d=1./b
      h=d
      do 11 i=1,ITMAX
        an=-i*(i-a)
        b=b+2.
        d=an*d+b
        if(abs(d).lt.FPMIN)d=FPMIN
        c=b+an/c
        if(abs(c).lt.FPMIN)c=FPMIN
        d=1./d
        del=d*c
        h=h*del
        if(abs(del-1.).lt.EPS)goto 1
11    continue
      pause 'a too large, ITMAX too small in gcf'
1     gammcf=exp(-x+a*log(x)-gln)*h
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      FUNCTION amotry(p,y,psum,mp,np,ndim,funk,ihi,fac)
      INTEGER ihi,mp,ndim,np,NMAX
      REAL amotry,fac,p(mp,np),psum(np),y(mp),funk
      PARAMETER (NMAX=20)
      EXTERNAL funk
CU    USES funk
      INTEGER j
      REAL fac1,fac2,ytry,ptry(NMAX)
      fac1=(1.-fac)/ndim
      fac2=fac1-fac
      do 11 j=1,ndim
        ptry(j)=psum(j)*fac1-p(ihi,j)*fac2
11    continue
      ytry=funk(ptry)
      if (ytry.lt.y(ihi)) then
        y(ihi)=ytry
        do 12 j=1,ndim
          psum(j)=psum(j)-p(ihi,j)+ptry(j)
          p(ihi,j)=ptry(j)
12      continue
      endif
      amotry=ytry
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      FUNCTION ran1(idum)
      INTEGER idum,IA,IM,IQ,IR,NTAB,NDIV
      REAL ran1,AM,EPS,RNMX
      PARAMETER (IA=16807,IM=2147483647,AM=1./IM,IQ=127773,IR=2836,
     *NTAB=32,NDIV=1+(IM-1)/NTAB,EPS=1.2e-7,RNMX=1.-EPS)
      INTEGER j,k,iv(NTAB),iy
      SAVE iv,iy
      DATA iv /NTAB*0/, iy /0/
      if (idum.le.0.or.iy.eq.0) then
        idum=max(-idum,1)
        do 11 j=NTAB+8,1,-1
          k=idum/IQ
          idum=IA*(idum-k*IQ)-IR*k
          if (idum.lt.0) idum=idum+IM
          if (j.le.NTAB) iv(j)=idum
11      continue
        iy=iv(1)
      endif
      k=idum/IQ
      idum=IA*(idum-k*IQ)-IR*k
      if (idum.lt.0) idum=idum+IM
      j=1+iy/NDIV
      iy=iv(j)
      iv(j)=idum
      ran1=min(AM*iy,RNMX)
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.
      FUNCTION gammln(xx)
      REAL gammln,xx
      INTEGER j
      DOUBLE PRECISION ser,stp,tmp,x,y,cof(6)
      SAVE cof,stp
      DATA cof,stp/76.18009172947146d0,-86.50532032941677d0,
     *24.01409824083091d0,-1.231739572450155d0,.1208650973866179d-2,
     *-.5395239384953d-5,2.5066282746310005d0/
      x=xx
      y=x
      tmp=x+5.5d0
      tmp=(x+0.5d0)*log(tmp)-tmp
      ser=1.000000000190015d0
      do 11 j=1,6
        y=y+1.d0
        ser=ser+cof(j)/y
11    continue
      gammln=tmp+log(stp*ser/x)
      return
      END
C  (C) Copr. 1986-92 Numerical Recipes Software *=D'.


       subroutine forec
       common /b1/y(5500),e(5500),b(30),g(30),h(30,30)
       common /b2/bb(30),w(15),w1(15),ylag(15)
       common /b4/p,pinc,q,qincp,qincm,ipar1,m,imi,ipar,ip(15),iq(15)
	common /b5/iresp(15),iresm(15)
       real pp(30),pred(5500)
       integer p,pinc,q,qincp,qincm,ipar1
       ipar2=ipar+1
	do 8 i=1,imi
8	e(i)=0
	do 9 i=m+1,m+10
9	e(i)=0
       do 90 it=imi,m
       f1=0
       f2=0
       f3=0
	   do 5 i=1,qincp
5	   if(e(it-iresp(i)).ge.0)
     a	   f1=f1+e(it-iresp(i))*b(i+pinc)
	   do 6 i=1,qincm
6	   if(e(it-iresm(i)).le.0)
     a     f2=f2+e(it-iresm(i))*b(i+ipar1)
           do 11 i=1,pinc
11         f3=f3+y(it-ip(i))*b(i)
        e(it)=y(it)-f1-f2-f3-pp(ipar2)
90     continue

       do 91 it=m+1,m+5
       f1=0
       f2=0
       f3=0
	   do 51 i=1,qincp
51	   if(e(it-iresp(i)).ge.0)
     a	   f1=f1+e(it-iresp(i))*b(i+pinc)
	   do 61 i=1,qincm
61	   if(e(it-iresm(i)).le.0)
     a     f2=f2+e(it-iresm(i))*b(i+ipar1)
           do 111 i=1,pinc
111         f3=f3+y(it-ip(i))*b(i)
	pred(it)=f1+f2+f3+b(ipar2)
91     continue


	do 10 i=m+1,m+4
10	write(3,100)i,pred(i)
100	format(i7,f20.5)
	   return
	   end
